//%attributes = {"publishedSql":true}
// Method: _blob Replace
// 2002.05.20-18:15:11 / Pasi Mankinen
// © Copyright 2002 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------

//by Michael Ginsberg, MDG Computer Services, http://www.mdg.com
//free to use and duplicate
//
//procedure BLOB_Replace
//BLOB_Position returns the starting position of the first occurrence of a string
//within a BLOB.
//Notes:
//   1. BLOBs are treated as arrays bytes, not characters. Each BLOB byte has a
//       numeric value, which can be converted to another form if desired.
//   2. BLOB bytes (i.e., the byte array elements) are numbered starting with
//       zero.
//-------------------------------------------------------------------------------
//   $1 is a pointer to the BLOB - also is the returned blob
//   $2 old string
//   $3 new string
//   $4 case sensitive
//   $5 offset


//    BlobReplace (->vBlob;$Search;$Replace;kFalse;0)

C_POINTER:C301($1)
C_TEXT:C284($2; $3)
C_LONGINT:C283($4)
C_LONGINT:C283($5; $_blob_lStartPos)
C_LONGINT:C283($_blob_llIndex; $_blob_lSearchLen; $_blob_lReplaceLen)

$_blob_lSearchLen:=Length:C16($2)
$_blob_lReplaceLen:=Length:C16($3)

$_blob_lStartPos:=$5
While ($_blob_lStartPos>=0)
	If ($4=kFalse)
		//$_blob_lStartPos:=_blob Position3 ($1;$2;$4;$_blob_lStartPos)
		TRACE:C157
		_err MESSAGE("Case insensitive blob replace does not work yet"; Current method name:C684; kFalse)
		$_blob_lStartPos:=_blob Position($1; $2; $_blob_lStartPos)  //works only case sensitive
	Else 
		$_blob_lStartPos:=_blob Position($1; $2; $_blob_lStartPos)  //works only case sensitive
	End if 
	If ($_blob_lStartPos>=0)
		If ($_blob_lSearchLen=$_blob_lReplaceLen)
			For ($_blob_llIndex; 1; $_blob_lSearchLen)
				$1->{$_blob_lStartPos+$_blob_llIndex-1}:=Character code:C91(Substring:C12($3; $_blob_llIndex; 1))
			End for 
		Else 
			DELETE FROM BLOB:C560($1->; $_blob_lStartPos; Length:C16($2))
			For ($_blob_llIndex; Length:C16($3); 1; -1)
				INSERT IN BLOB:C559($1->; $_blob_lStartPos; 1; Character code:C91(Substring:C12($3; $_blob_llIndex; 1)))
			End for 
		End if 
	End if 
End while 

//OLD
//C_TEXT($1;$pattern)
//C_TEXT($2;$replacement)
//C_POINTER($3;$targetTextPtr)
//C_LONGINT($4;$flags)
//C_LONGINT($0;$err)
//
//$pattern:=$1
//$replacement:=$2
//$targetTextPtr:=$3
//If (Count parameters>3)
//  $flags:=$4
//Else 
//  $flags:=0
//End if 
//
//C_BLOB($targetBlob)
//TEXT TO BLOB($targetTextPtr->;$targetBlob;Mac text without length )
//
//$err:=QF_RESubstitute ($pattern;$replacement;$targetBlob;$flags)
//If ($err=0)
//  $targetTextPtr->:=BLOB to text($targetBlob;Mac text without length )
//End if 
//
//$0:=$err
